package.path = package.path ..';./Scripts/DemoScenes/?.lua;'
local sceneEnvironment = require("demosceneEnvironment")

scene = {}

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	sceneAPI:setUpdateFunc('sceneVRUpdate')

	sceneAPI:setSky(true);
	sceneAPI:setCirrus(true);
	sceneAPI:setSun(math.rad(175), math.rad(355));

	scene.m			= sceneAPI:addModel("fa-18c", 3.0, 20.5, -3);
	scene.m:setLivery("VMFA-232 high visibility", "FA-18C_hornet");
	scene.m.transform:setOrient(0,0,0);
	scene.m:setArgument(0, 1);
	scene.m:setArgument(1, 0.65);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(4, 0.85);
	scene.m:setArgument(6, 0.85);
	scene.m:setArgument(9, 0.5)
	scene.m:setArgument(10, 0.5)
	scene.m:setArgument(11, -0.5)
	scene.m:setArgument(12, -0.5)
	scene.m:setArgument(13, 0.4)
	scene.m:setArgument(14, 0.4)
	scene.m:setArgument(15, 0.3)
	scene.m:setArgument(16, 0.3)
	scene.m:setArgument(39, 0.7)
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);

	local cam_level = 20.3

	scene.cam		= sceneAPI:addCamera(6, cam_level , 6)
	scene.cam:setFarClip(1000000.0)
	scene.cam:setFov(90)
	scene.cam.transform:lookAtPoint(-10.0, cam_level, 3);

	scene.sh		= sceneAPI:addModel("Nimitz_CVN_71", -54.0, -1.5, 0.95); 
	scene.sh:drawToEnvironment(true);

	scene.cam:setActive()
end

--[0;1]
local function pingpong(length, t)
	local tt = (t%length)*2/length
	if tt>1 then tt = 2-tt end
	return tt
end


function sceneVRUpdate(t, dt)

end